---
title: Fetch HTML · Cloudflare Workers docs
description: Send a request to a remote server, read HTML from the response, and
  serve that HTML.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python
source_url:
  html: https://developers.cloudflare.com/workers/examples/fetch-html/
  md: https://developers.cloudflare.com/workers/examples/fetch-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/fetch-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      /**
       * Replace `remote` with the host you wish to send requests to
       */
      const remote = "https://example.com";


      return await fetch(remote, request);
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwAOQQHYAzADZJATgCMogFwsWbYBzhcafASPHS5iwQFgAUAGF0VCAFMb2ACJQAzjHQuo0a0pLq8BMQkVHDAtgwARFA0tgAeAHQAVi4RpKhQYPah4VExCckR5lY29hDYACp0MLa+cDAwYHwEUNbIiXAAbnAuvAiwEADUwOi44Lbm5nHuSCS4tqhw4BAkAN5mJCTddFS8frYQvAAWABQItgCOILYuEACUq+sbJMgAVC+PTy8kAEq2DXC8WwkAAGZ2GdmBJAA7l5DiQIIcgYcPMs6JRoa44RB0CQXPZcCQzpdrhAXPD0B8Ni9kJTeNYboTbOCgQwSBFDhAIDAXEpkMg4qEGrZ4nTgKkzJSzhAQAgqJsoXAvHsDicweg7AAaRnEm63IiPAC+GrMBqI5lUzHUmm0PH4QlEkhkEgUoiK1jsDmcbg8XhaVF8-k0pBCYUiYUImlSfgyWVDETIYHQZEKlndpQqVRqm3qjV4zVayWsEzMKwiwEVVAA+sNRpkIkpcnN8ikDeaLVbAjbdPaDE6XYJmOYgA)

* TypeScript

  ```ts
  export default {
    async fetch(request: Request): Promise<Response> {
      /**
       * Replace `remote` with the host you wish to send requests to
       */
      const remote = "https://example.com";


      return await fetch(remote, request);
    },
  };
  ```

* Python

  ```py
  from workers import WorkerEntrypoint
  from js import fetch


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          # Replace `remote` with the host you wish to send requests to
          remote = "https://example.com"
          return await fetch(remote, request)
  ```

* Hono

  ```ts
  import { Hono } from "hono";


  const app = new Hono();


  app.all("*", async (c) => {
    /**
     * Replace `remote` with the host you wish to send requests to
     */
    const remote = "https://example.com";


    // Forward the request to the remote server
    return await fetch(remote, c.req.raw);
  });


  export default app;
  ```
