---
title: IP Access rules · Cloudflare Web Application Firewall (WAF) docs
description: Use IP Access rules to allowlist, block, and challenge traffic
  based on the visitor's IP address, Autonomous System Number (ASN), or country.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/ip-access-rules/
  md: https://developers.cloudflare.com/waf/tools/ip-access-rules/index.md
---

Use IP Access rules to allowlist, block, and challenge traffic based on the visitor's IP address, Autonomous System Number (ASN), or country.

IP Access rules are commonly used to block or challenge suspected malicious traffic. Another common use of IP Access rules is to allow services that regularly access your site, such as APIs, crawlers, and payment providers.

Warning

Allowing an IP or ASN will bypass any configured [custom rules](https://developers.cloudflare.com/waf/custom-rules/), [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/), and firewall rules (deprecated).

For important notes about allowing or blocking traffic by country, refer to [Important remarks about allowing/blocking by country](#important-remarks-about-allowingblocking-by-country).

## Important remarks about allowing/blocking by country

Block by country is only available on Enterprise plans.

IP addresses globally allowed by Cloudflare will override an IP Access rule country block, but they will not override a country block via [custom rules](https://developers.cloudflare.com/waf/custom-rules/).

Allowing a country will:

* Bypass any configured [custom rules](https://developers.cloudflare.com/waf/custom-rules/), [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), and firewall rules (deprecated).
* Not bypass [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/) or [WAF managed rules (previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/).

## Recommendation: Use custom rules instead

Cloudflare recommends that you create [custom rules](https://developers.cloudflare.com/waf/custom-rules/) instead of IP Access rules to perform IP-based or geography-based blocking (geoblocking):

* For IP-based blocking, use an [IP list](https://developers.cloudflare.com/waf/tools/lists/custom-lists/#ip-lists) in the custom rule expression. Refer to [Allow traffic from IP addresses in allowlist only](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-ips-in-allowlist/) for an example.
* For geoblocking, use fields such as *AS Num*, *Country*, and *Continent* in the custom rule expression. Refer to [Block traffic from specific countries](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-traffic-from-specific-countries/) for an example.

***

## Availability

IP Access rules are available to all customers.

Each Cloudflare account can have a maximum of 50,000 rules. If you are an Enterprise customer and need more rules, contact your account team.

Block by country is only available on the Enterprise plan. Other customers may perform country blocking using [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/).

## Final remarks

* By design, IP Access rules configured to *Allow* traffic do not show up in [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/).

* Requests containing certain attack patterns in the `User-Agent` field are checked before being processed by the general firewall pipeline. Therefore, such requests are blocked before any allowlist logic takes place. When this occurs, security events downloaded from the API show `rule_id` as `security_level` and action as `drop`.

* Cloudflare supports use of `fail2ban` to block IPs on your server. However, to prevent `fail2ban` from inadvertently blocking Cloudflare IPs and causing errors for some visitors, ensure you restore original visitor IP in your origin server logs. For details, refer to [Restoring original visitor IPs](https://developers.cloudflare.com/support/troubleshooting/restoring-visitor-ips/restoring-original-visitor-ips/).

## Related resources

To learn more about protection options provided by Cloudflare to protect your website against malicious traffic and bad actors, refer to [Secure your website](https://developers.cloudflare.com/learning-paths/application-security/account-security/).
