---
title: Block traffic by geographical location · Cloudflare Web Application
  Firewall (WAF) docs
description: This example custom rule blocks requests by autonomous system
  number (ASN), continent, country of origin, or region.
lastUpdated: 2025-08-08T14:01:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-by-geographical-location/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-by-geographical-location/index.md
---

This example custom rule blocks requests by autonomous system number (ASN), continent, country of origin, or region.

* **Expression**: `(ip.src.asnum eq 131279) or (ip.src.continent eq "AS") or (ip.src.country eq "KP") or (ip.src.region_code eq "CA")`
* **Action**: *Block*

## Other resources

* [Use case: Block traffic from specific countries](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-traffic-from-specific-countries/)
* [Use case: Allow traffic from specific countries only](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-specific-countries/)
* [Fields reference: Geolocation](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/?field-category=Geolocation)
