---
title: Work with custom rulesets · Cloudflare Ruleset Engine docs
description: "Use the following workflow to deploy a custom ruleset at the account level:"
lastUpdated: 2025-04-16T19:24:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/custom-rulesets/
  md: https://developers.cloudflare.com/ruleset-engine/custom-rulesets/index.md
---

Use the following workflow to deploy a custom ruleset at the account level:

1. [Create a custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/create-custom-ruleset/).
2. [Add rules to your custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/add-rules-ruleset/).
3. [Add a rule to an account-level phase entry point ruleset that executes the custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/deploy-custom-ruleset/).

You must create a rule with `execute` action in an entry point ruleset to execute the custom ruleset (step 3 in the previous procedure). If you skip this step, the rules of the custom ruleset will not run.

Currently, custom rulesets are only supported by the [Cloudflare WAF](https://developers.cloudflare.com/waf/).

Note

You cannot execute a custom ruleset from another custom ruleset, only from an entry point ruleset.

## Change the behavior of a custom ruleset

To modify custom ruleset behavior, Cloudflare recommends [creating a new custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/create-custom-ruleset/) or [editing the custom ruleset](https://developers.cloudflare.com/ruleset-engine/custom-rulesets/add-rules-ruleset/) instead of using overrides.
