---
title: Origin Rules settings · Cloudflare Rules docs
description: The following sections describe the available settings in Origin Rules.
lastUpdated: 2025-09-11T15:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/origin-rules/features/
  md: https://developers.cloudflare.com/rules/origin-rules/features/index.md
---

The following sections describe the available settings in Origin Rules.

## Host header

Allows you to rewrite the HTTP `Host` header of incoming requests.

A common use case for this functionality is when your content is hosted on a third-party server that only accepts `Host` headers with their own server names. In this situation, you must update the `Host` HTTP header in incoming requests from `Host: example.com` to `Host: thirdpartyserver.example.net`.

Notes

* In most situations, when you rewrite the HTTP `Host` header you also need to configure a [DNS record override](#dns-record). The `Host` header override only updates the header value; the DNS record override will handle the rerouting of the request.

* An origin rule performing a `Host` header override will also update the Server Name Indication (SNI) value of the original request to the same value. To set an SNI value different from the `Host` header value, add an [SNI override](#server-name-indication-sni) in the same origin rule or create a separate origin rule for this purpose.

* If you have configured load balancing through Cloudflare and you wish to override the HTTP `Host` header per origin or for a given monitor, refer to [Override HTTP Host headers](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/) in the Load Balancing documentation for more information.

## Server Name Indication (SNI)

Allows you to override the Server Name Indication (SNI) [1](#user-content-fn-1) value of a request. For more information, refer to [What is SNI (Server Name Indication)?](https://www.cloudflare.com/learning/ssl/what-is-sni/) in the Learning Center.

Notes

* The new SNI value must be a valid hostname on the same Cloudflare account (possibly on a different zone).
* Currently, you can only use a static value when overriding SNI.
* An SNI override will take precedence over [SNI rewrites of custom origins](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/#sni-rewrites) when using Cloudflare for SaaS.

## DNS record

Allows you to override the resolved hostname of incoming requests. This functionality is also known as resolve override.

A common use case is when you are serving an application from the URI (for example, `mydomain.com/app`). In this case, the `app` may be hosted on a different server or by a third party. A DNS record override allows you to redirect requests to this endpoint to the server for that third-party application.

Note

* You must specify a valid hostname in a DNS record override that is a hostname on the same Cloudflare account (possibly on a different zone). You can [configure a DNS record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records#create-dns-records) (a `CNAME`, `A`, or `AAAA` record) with a hostname pointing to a third-party hostname/IP address, either proxied by Cloudflare or not.

* In most situations, when you configure a DNS record override you also need to configure a [`Host` header override](#host-header). The DNS record override handles the rerouting of the request; the `Host` header override updates the `Host` HTTP header value in the request. Defining a `Host` header override will also update the Server Name Indication (SNI) value of the original request to the same value. To set an SNI value different from the `Host` header value, add an [SNI override](#server-name-indication-sni) in the same origin rule or create a separate origin rule for this purpose.

The following example DNS records configure a `resolve.example.com` hostname pointing to an external hostname and IP address using a `CNAME` record and an `A` record, respectively:

**Example `CNAME` record**

* **Type:** *CNAME*
* **Name:** `resolve.example.com`
* **Target:** `domain.s3.amazonaws.com`
* **TTL:** `Auto`
* **Proxy status:** *Proxied* (orange cloud icon)

**Example `A` record**

* **Type:** *A*
* **Name:** `resolve.example.com`
* **IPv4 address:** `203.0.113.1`
* **TTL:** `Auto`
* **Proxy status:** *Proxied* (orange cloud icon)

## Destination port

Allows you to override the destination port of a request.

When you configure a destination port override, you can redirect incoming requests to a different port. For example, you could override the destination port for requests received for `mydomain.com` so that they are served by the application running on port 9000 (`mydomain.com:9000`).

The destination port must be between 1 and 65,535.

## Footnotes

1. SNI allows a server to host multiple TLS Certificates for multiple websites using a single IP address. SNI adds the website hostname in the TLS handshake to inform the server which website to present when using shared IPs. [↩](#user-content-fnref-1)
