---
title: Digital experience · Cloudflare One docs
description: Digital Experience Monitoring (DEX) provides visibility into
  device, network, and application performance across your Zero Trust
  organization.
lastUpdated: 2025-10-29T14:53:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/dex/
  md: https://developers.cloudflare.com/cloudflare-one/insights/dex/index.md
---

Digital Experience Monitoring (DEX) provides visibility into device, network, and application performance across your Zero Trust organization.

With DEX, you can monitor the state of your [WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) deployment and resolve issues impacting end-user productivity. DEX is designed for IT and security teams who need to proactively monitor and troubleshoot device and network health across distributed environments. DEX is available on all Cloudflare Zero Trust and SASE plans.

Use DEX to troubleshoot other Zero Trust features:

* Test connectivity to a [SaaS application secured with Access](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/).
* Verify that a website routed through [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) is reachable from user devices.
* Confirm that users can successfully reach internal resources after configuring a [Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/).

### Get started

To start using DEX for device, network, and application monitoring:

1. [Create a Zero Trust organization](https://developers.cloudflare.com/cloudflare-one/setup/#create-a-zero-trust-organization).
2. [Install the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) and sign in to register your device to the organization.
3. Create [tests](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/) to verify device connectivity to applications and networks.
4. [Monitor](https://developers.cloudflare.com/cloudflare-one/insights/dex/monitoring/) device and network health across your fleet using real-time and historical metrics.
5. Run [remote captures](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/) to collect diagnostic logs and packet captures from user devices.
6. Set up [notifications](https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/) to get alerts when degraded connectivity or application performance is detected.

### Directory

Review all available documentation for DEX capabilities.

* [Device monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/monitoring/)
* [Synthetic tests](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/)
* [Rules](https://developers.cloudflare.com/cloudflare-one/insights/dex/rules/)
* [Remote captures](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/)
* [Notifications](https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/)
* [IP visibility](https://developers.cloudflare.com/cloudflare-one/insights/dex/ip-visibility/)
* [DEX MCP server](https://developers.cloudflare.com/cloudflare-one/insights/dex/dex-mcp-server/)
* [MCP server](https://github.com/cloudflare/mcp-server-cloudflare/tree/main/apps/dex-analysis)
