---
title: IP address service bindings · Cloudflare BYOIP docs
description: In IP address management, service binding refers to the association
  of IPs to specific Cloudflare services. Review the available options and the
  API endpoints to set up service bindings.
lastUpdated: 2025-09-23T20:48:09.000Z
chatbotDeprioritize: false
tags: Bindings
source_url:
  html: https://developers.cloudflare.com/byoip/service-bindings/
  md: https://developers.cloudflare.com/byoip/service-bindings/index.md
---

Service bindings are mappings that control whether traffic destined for a given IP address is routed to [Magic Transit](https://developers.cloudflare.com/magic-transit/), the CDN pipeline [1](#user-content-fn-1), or the Spectrum pipeline [2](#user-content-fn-2).

Note

Service binding operations are currently only available via API. You can find all endpoints and their specifications in the [Cloudflare API documentation](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/service_bindings/).

## Scope

Customers using BYOIP with Magic Transit, [CDN services](https://developers.cloudflare.com/cache/), or [Spectrum](https://developers.cloudflare.com/spectrum/) can leverage the [service binding API endpoints](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/service_bindings/) to selectively route traffic through the CDN [1](#user-content-fn-1) or Spectrum [2](#user-content-fn-2) pipelines on a per-IP address basis. This means:

* You can upgrade individual IPs within a Magic Transit prefix to either a CDN IP or a Spectrum IP. For example, if you have a Magic Transit prefix `203.0.113.0/24`, you can upgrade `203.0.113.1` to CDN and `203.0.113.2` to Spectrum.
* You can upgrade individual IPs within a CDN prefix to a Spectrum IP. For example, if you have a CDN prefix `203.0.113.0/24`, you can upgrade `203.0.113.1` to Spectrum.
* You can upgrade individual IPs within a Spectrum prefix to a CDN IP. For example, if you have a Spectrum prefix `203.0.113.0/24`, you can upgrade `203.0.113.1` to CDN.

Refer to [Magic Transit with CDN](https://developers.cloudflare.com/byoip/service-bindings/magic-transit-with-cdn/) or [CDN and Spectrum](https://developers.cloudflare.com/byoip/service-bindings/cdn-and-spectrum/) for detailed guidance.

Warning

Magic Transit customers must ensure that their contract includes CDN and/or Spectrum according to their needs.

### CDN (Cache)

When a service binding of type `CDN` is applied, once the change has propagated across Cloudflare's global network (four to six hours), any HTTP requests are directed into the CDN pipeline for Layer 7 processing.

### Spectrum

When a service binding of type `Spectrum` is applied, once the change has propagated across Cloudflare's global network (four to six hours), any TCP/UDP/HTTP requests are directed into the Spectrum pipeline for Layer 4 or Layer 7 processing.

## Limitations

* When adding a service binding for a given IP address, it must be either a CDN service binding or a Spectrum service binding. It is not possible (or necessary) to bind both services.
* Once a service binding is created (or deleted), it will take four to six hours to propagate across Cloudflare's global network. Services for the IP addresses in scope will likely be disrupted during this window.

## Footnotes

1. Layer 7 HTTP-based [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2)

2. Layer 4 or Layer 7 HTTP with custom ports [↩](#user-content-fnref-2) [↩2](#user-content-fnref-2-2)
